<?php

// Code generated by OpenAPI Generator (https://openapi-generator.tech), manual changes will be lost - read more on https://github.com/algolia/api-clients-automation. DO NOT EDIT.

namespace Algolia\AlgoliaSearch\Model\AbtestingV3;

use Algolia\AlgoliaSearch\Model\AbstractModel;
use Algolia\AlgoliaSearch\Model\ModelInterface;

/**
 * MetricResult Class Doc Comment.
 *
 * @category Class
 */
class MetricResult extends AbstractModel implements ModelInterface, \ArrayAccess, \JsonSerializable
{
    /**
     * Array of property to type mappings. Used for (de)serialization.
     *
     * @var string[]
     */
    protected static $modelTypes = [
        'name' => 'string',
        'updatedAt' => 'string',
        'value' => 'float',
        'valueCIHigh' => 'float',
        'valueCILow' => 'float',
        'pValue' => 'float',
        'dimension' => 'string',
        'metadata' => '\Algolia\AlgoliaSearch\Model\AbtestingV3\MetricMetadata',
        'criticalValue' => 'float',
        'significant' => 'bool',
    ];

    /**
     * Array of property to format mappings. Used for (de)serialization.
     *
     * @var string[]
     */
    protected static $modelFormats = [
        'name' => null,
        'updatedAt' => null,
        'value' => 'double',
        'valueCIHigh' => 'double',
        'valueCILow' => 'double',
        'pValue' => 'double',
        'dimension' => null,
        'metadata' => null,
        'criticalValue' => 'double',
        'significant' => null,
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name.
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'name' => 'name',
        'updatedAt' => 'updatedAt',
        'value' => 'value',
        'valueCIHigh' => 'valueCIHigh',
        'valueCILow' => 'valueCILow',
        'pValue' => 'pValue',
        'dimension' => 'dimension',
        'metadata' => 'metadata',
        'criticalValue' => 'criticalValue',
        'significant' => 'significant',
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses).
     *
     * @var string[]
     */
    protected static $setters = [
        'name' => 'setName',
        'updatedAt' => 'setUpdatedAt',
        'value' => 'setValue',
        'valueCIHigh' => 'setValueCIHigh',
        'valueCILow' => 'setValueCILow',
        'pValue' => 'setPValue',
        'dimension' => 'setDimension',
        'metadata' => 'setMetadata',
        'criticalValue' => 'setCriticalValue',
        'significant' => 'setSignificant',
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests).
     *
     * @var string[]
     */
    protected static $getters = [
        'name' => 'getName',
        'updatedAt' => 'getUpdatedAt',
        'value' => 'getValue',
        'valueCIHigh' => 'getValueCIHigh',
        'valueCILow' => 'getValueCILow',
        'pValue' => 'getPValue',
        'dimension' => 'getDimension',
        'metadata' => 'getMetadata',
        'criticalValue' => 'getCriticalValue',
        'significant' => 'getSignificant',
    ];

    /**
     * Associative array for storing property values.
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor.
     *
     * @param mixed[] $data Associated array of property values
     */
    public function __construct(?array $data = null)
    {
        if (isset($data['name'])) {
            $this->container['name'] = $data['name'];
        }
        if (isset($data['updatedAt'])) {
            $this->container['updatedAt'] = $data['updatedAt'];
        }
        if (isset($data['value'])) {
            $this->container['value'] = $data['value'];
        }
        if (isset($data['valueCIHigh'])) {
            $this->container['valueCIHigh'] = $data['valueCIHigh'];
        }
        if (isset($data['valueCILow'])) {
            $this->container['valueCILow'] = $data['valueCILow'];
        }
        if (isset($data['pValue'])) {
            $this->container['pValue'] = $data['pValue'];
        }
        if (isset($data['dimension'])) {
            $this->container['dimension'] = $data['dimension'];
        }
        if (isset($data['metadata'])) {
            $this->container['metadata'] = $data['metadata'];
        }
        if (isset($data['criticalValue'])) {
            $this->container['criticalValue'] = $data['criticalValue'];
        }
        if (isset($data['significant'])) {
            $this->container['significant'] = $data['significant'];
        }
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name.
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of property to type mappings. Used for (de)serialization.
     *
     * @return array
     */
    public static function modelTypes()
    {
        return self::$modelTypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization.
     *
     * @return array
     */
    public static function modelFormats()
    {
        return self::$modelFormats;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses).
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests).
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        if (!isset($this->container['name']) || null === $this->container['name']) {
            $invalidProperties[] = "'name' can't be null";
        }
        if (!isset($this->container['updatedAt']) || null === $this->container['updatedAt']) {
            $invalidProperties[] = "'updatedAt' can't be null";
        }
        if (!isset($this->container['value']) || null === $this->container['value']) {
            $invalidProperties[] = "'value' can't be null";
        }
        if (!isset($this->container['pValue']) || null === $this->container['pValue']) {
            $invalidProperties[] = "'pValue' can't be null";
        }

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed.
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return 0 === count($this->listInvalidProperties());
    }

    /**
     * Gets name.
     *
     * @return string
     */
    public function getName()
    {
        return $this->container['name'] ?? null;
    }

    /**
     * Sets name.
     *
     * @param string $name name
     *
     * @return self
     */
    public function setName($name)
    {
        $this->container['name'] = $name;

        return $this;
    }

    /**
     * Gets updatedAt.
     *
     * @return string
     */
    public function getUpdatedAt()
    {
        return $this->container['updatedAt'] ?? null;
    }

    /**
     * Sets updatedAt.
     *
     * @param string $updatedAt date and time when the metric was last updated, in RFC 3339 format
     *
     * @return self
     */
    public function setUpdatedAt($updatedAt)
    {
        $this->container['updatedAt'] = $updatedAt;

        return $this;
    }

    /**
     * Gets value.
     *
     * @return float
     */
    public function getValue()
    {
        return $this->container['value'] ?? null;
    }

    /**
     * Sets value.
     *
     * @param float $value value
     *
     * @return self
     */
    public function setValue($value)
    {
        $this->container['value'] = $value;

        return $this;
    }

    /**
     * Gets valueCIHigh.
     *
     * @return null|float
     */
    public function getValueCIHigh()
    {
        return $this->container['valueCIHigh'] ?? null;
    }

    /**
     * Sets valueCIHigh.
     *
     * @param null|float $valueCIHigh The upper bound of the 95% confidence interval for the metric value. The confidence interval is calculated using either the relative ratio or relative difference between the metric values for the control and the variant. Relative ratio is used for metrics that are ratios (e.g., click-through rate, conversion rate), while relative difference is used for continuous metrics (e.g., revenue).
     *
     * @return self
     */
    public function setValueCIHigh($valueCIHigh)
    {
        $this->container['valueCIHigh'] = $valueCIHigh;

        return $this;
    }

    /**
     * Gets valueCILow.
     *
     * @return null|float
     */
    public function getValueCILow()
    {
        return $this->container['valueCILow'] ?? null;
    }

    /**
     * Sets valueCILow.
     *
     * @param null|float $valueCILow The lower bound of the 95% confidence interval for the metric value. The confidence interval is calculated using either the relative ratio or relative difference between the metric values for the control and the variant. Relative ratio is used for metrics that are ratios (e.g., click-through rate, conversion rate), while relative difference is used for continuous metrics (e.g., revenue).
     *
     * @return self
     */
    public function setValueCILow($valueCILow)
    {
        $this->container['valueCILow'] = $valueCILow;

        return $this;
    }

    /**
     * Gets pValue.
     *
     * @return float
     */
    public function getPValue()
    {
        return $this->container['pValue'] ?? null;
    }

    /**
     * Sets pValue.
     *
     * @param float $pValue PValue for the first variant (control) will always be 0. For the other variants, pValue is calculated for the current variant based on the control.
     *
     * @return self
     */
    public function setPValue($pValue)
    {
        $this->container['pValue'] = $pValue;

        return $this;
    }

    /**
     * Gets dimension.
     *
     * @return null|string
     */
    public function getDimension()
    {
        return $this->container['dimension'] ?? null;
    }

    /**
     * Sets dimension.
     *
     * @param null|string $dimension dimension defined during test creation
     *
     * @return self
     */
    public function setDimension($dimension)
    {
        $this->container['dimension'] = $dimension;

        return $this;
    }

    /**
     * Gets metadata.
     *
     * @return null|MetricMetadata
     */
    public function getMetadata()
    {
        return $this->container['metadata'] ?? null;
    }

    /**
     * Sets metadata.
     *
     * @param null|MetricMetadata $metadata metadata
     *
     * @return self
     */
    public function setMetadata($metadata)
    {
        $this->container['metadata'] = $metadata;

        return $this;
    }

    /**
     * Gets criticalValue.
     *
     * @return null|float
     */
    public function getCriticalValue()
    {
        return $this->container['criticalValue'] ?? null;
    }

    /**
     * Sets criticalValue.
     *
     * @param null|float $criticalValue The value that was computed during error correction. It is used to determine significance of the metric pValue. The critical value is calculated using Bonferroni or Benjamini-Hochberg corrections, based on the given configuration during the A/B test creation.
     *
     * @return self
     */
    public function setCriticalValue($criticalValue)
    {
        $this->container['criticalValue'] = $criticalValue;

        return $this;
    }

    /**
     * Gets significant.
     *
     * @return null|bool
     */
    public function getSignificant()
    {
        return $this->container['significant'] ?? null;
    }

    /**
     * Sets significant.
     *
     * @param null|bool $significant whether the pValue is significant or not based on the critical value and the error correction algorithm used
     *
     * @return self
     */
    public function setSignificant($significant)
    {
        $this->container['significant'] = $significant;

        return $this;
    }

    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param int $offset Offset
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param int $offset Offset
     *
     * @return null|mixed
     */
    public function offsetGet($offset): mixed
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param null|int $offset Offset
     * @param mixed    $value  Value to be set
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param int $offset Offset
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }
}
