@extends('backend.layouts.app')

@section('content')

<div class="aiz-titlebar text-left mt-2 mb-3 pb-2 border-bottom border-gray">
	<div class="row align-items-center">
		<div class="col">
			<h1 class="h3">{{ translate('Authentication Page Layout') }}</h1>
		</div>
	</div>
</div>
<div class="card rounded-0">
	<div class="card-body p-2rem">
		<form action="{{ route('business_settings.update') }}" method="POST" enctype="multipart/form-data">
			@csrf
			<input type="hidden" name="types[]" value="authentication_layout_select">
			@php $authentication_layout = get_setting('authentication_layout_select'); @endphp
			<div class="row">

				<!-- Boxed -->
				<div class="col-xxl-3 col-lg-4 col-sm-6 my-3">
					<label class="aiz-megabox d-block mb-3">
						<input value="boxed" type="radio" name="authentication_layout_select" @if(($authentication_layout == null) || ($authentication_layout == 'boxed')) checked @endif>
						<span class="d-block aiz-megabox-elem rounded-0 img-overlay">
							<div class="h-190px w-100 overflow-hidden">
								<img src="{{ static_asset('assets/img/authentication_pages/boxed.png') }}" class="w-100" alt="authentication-page">
							</div>
						</span>
					</label>
					<div class="d-flex flex-wrap justify-content-between align-items-center">
						<span class="fs-14 fw-500 text-dark">{{ translate('Authentication Layout 1 - Boxed') }}</span>
						<span>
							<a href="javascript:void(0);" class="btn btn-xs btn-danger rounded-0"
								onclick="imageShowOverlay('{{ static_asset('assets/img/authentication_pages/boxed.png') }}')">{{ translate('View') }}</a>
						</span>
					</div>
				</div>

				<!-- Free 2 -->
				<div class="col-xxl-3 col-lg-4 col-sm-6 my-3">
					<label class="aiz-megabox d-block mb-3">
						<input value="free" type="radio" name="authentication_layout_select" @if($authentication_layout == 'free') checked @endif>
						<span class="d-block aiz-megabox-elem rounded-0 img-overlay">
							<div class="h-190px w-100 overflow-hidden">
								<img src="{{ static_asset('assets/img/authentication_pages/free.png') }}" class="w-100" alt="authentication-page">
							</div>
						</span>
					</label>
					<div class="d-flex flex-wrap justify-content-between align-items-center">
						<span class="fs-14 fw-500 text-dark">{{ translate('Authentication Layout 2 - Free') }}</span>
						<span>
							<a href="javascript:void(0);" class="btn btn-xs btn-danger rounded-0"
								onclick="imageShowOverlay('{{ static_asset('assets/img/authentication_pages/free.png') }}')">{{ translate('View') }}</a>
						</span>
					</div>
				</div>

				<!-- Focused -->
				<div class="col-xxl-3 col-lg-4 col-sm-6 my-3">
					<label class="aiz-megabox d-block mb-3">
						<input value="focused" type="radio" name="authentication_layout_select" @if($authentication_layout == 'focused') checked @endif>
						<span class="d-block aiz-megabox-elem rounded-0 img-overlay">
							<div class="h-190px w-100 overflow-hidden">
								<img src="{{ static_asset('assets/img/authentication_pages/focused.png') }}" class="w-100" alt="authentication-page">
							</div>
						</span>
					</label>
					<div class="d-flex flex-wrap justify-content-between align-items-center">
						<span class="fs-14 fw-500 text-dark">{{ translate('Authentication Layout 3 - Focused') }}</span>
						<span>
							<a href="javascript:void(0);" class="btn btn-xs btn-danger rounded-0"
								onclick="imageShowOverlay('{{ static_asset('assets/img/authentication_pages/focused.png') }}')">{{ translate('View') }}</a>
						</span>
					</div>
				</div>
			</div>
			<div class="row bg-light p-3 mt-5">
				<div class="col-md-8 d-none d-md-block">
					<div class="d-flex align-items-center">
						<div class="text-secondary mr-3"><i class="las la-4x la-sliders-h"></i></div>
						<div>
							<h4 class="fs-16 text-secondary">{{ translate('Configure your authentication page layout') }}</h4>
							<small class="fs-12 text-secondary">{{ translate('Each page contain different layout, choose one to bundle it in your Layout.') }}</small>
						</div>
					</div>
				</div>
				<div class="col-md-4 d-flex align-items-center justify-content-end">
					<!-- Save Button -->
					<button type="submit" class="btn btn-success w-230px btn-md rounded-2 fs-14 fw-700 shadow-success">{{ translate('Save') }}</button>
				</div>
			</div>
		</form>
	</div>
</div>

<!-- Authentication Page Images -->
<div class="aiz-titlebar border-bottom border-gray mb-3 mt-2 mt-md-5 pb-2 text-left">
	<div class="row align-items-center">
		<div class="col">
			<h1 class="h3">{{ translate('Authentication Page Images') }}</h1>
		</div>
	</div>
</div>

<div class="card">
	<div class="card-body">
		<form action="{{ route('business_settings.update') }}" method="POST">
			@csrf

			<div class="row">
				<!-- Admin Login Page Image -->
				<div class="form-group col-lg-6">
					<label class="from-label fs-13">{{translate('Admin login Page Image')}}</label>
					<div class="input-group" data-toggle="aizuploader" data-type="image">
						<div class="input-group-prepend">
							<div class="input-group-text bg-soft-secondary">{{ translate('Browse') }}</div>
						</div>
						<div class="form-control file-amount">{{ translate('Choose Files') }}</div>
						<input type="hidden" name="types[]" value="admin_login_page_image">
						<input type="hidden" name="admin_login_page_image" value="{{ get_setting('admin_login_page_image') }}" class="selected-files">
					</div>
					<div class="file-preview box"></div>
                    <small class="text-muted">{{ translate("Minimum dimensions required: 960px width X 911px height.") }}</small>
				</div>

				<!-- Customer Login page Image -->
				<div class="form-group col-lg-6">
					<label class="from-label fs-13">{{ translate('Customer Login page Image') }}</label>
					<div class="input-group " data-toggle="aizuploader" data-type="image">
						<div class="input-group-prepend">
							<div class="input-group-text bg-soft-secondary">{{ translate('Browse') }}</div>
						</div>
						<div class="form-control file-amount">{{ translate('Choose File') }}</div>
						<input type="hidden" name="types[]" value="customer_login_page_image">
						<input type="hidden" name="customer_login_page_image" value="{{ get_setting('customer_login_page_image') }}" class="selected-files">
					</div>
					<div class="file-preview box"></div>
                    <small class="text-muted">{{ translate("Minimum dimensions required: 945px width X 839px height.") }}</small>
				</div>

				<!-- Customer Register page Image -->
				<div class="form-group col-lg-6">
					<label class="from-label fs-13">{{ translate('Customer Register Page Image') }}</label>
					<div class="input-group " data-toggle="aizuploader" data-type="image">
						<div class="input-group-prepend">
							<div class="input-group-text bg-soft-secondary">{{ translate('Browse') }}</div>
						</div>
						<div class="form-control file-amount">{{ translate('Choose File') }}</div>
						<input type="hidden" name="types[]" value="customer_register_page_image">
						<input type="hidden" name="customer_register_page_image" value="{{ get_setting('customer_register_page_image') }}" class="selected-files">
					</div>
					<div class="file-preview box"></div>
                    <small class="text-muted">{{ translate("Minimum dimensions required: 937px width X 965px height.") }}</small>
				</div>

				@if (get_setting('vendor_system_activation') == 1)
					<!-- Seller Login page Image -->
					<div class="form-group col-lg-6">
						<label class="from-label fs-13">{{ translate('Seller Login Page Image') }}</label>
						<div class="input-group " data-toggle="aizuploader" data-type="image">
							<div class="input-group-prepend">
								<div class="input-group-text bg-soft-secondary">{{ translate('Browse') }}</div>
							</div>
							<div class="form-control file-amount">{{ translate('Choose File') }}</div>
							<input type="hidden" name="types[]" value="seller_login_page_image">
							<input type="hidden" name="seller_login_page_image" value="{{ get_setting('seller_login_page_image') }}" class="selected-files">
						</div>
						<div class="file-preview box"></div>
                    <small class="text-muted">{{ translate("Minimum dimensions required: 945px width X 839px height.") }}</small>
					</div>

					<!-- Seller Register page Image -->
					<div class="form-group col-lg-6">
						<label class="from-label fs-13">{{ translate('Seller Register Page Image') }}</label>
						<div class="input-group " data-toggle="aizuploader" data-type="image">
							<div class="input-group-prepend">
								<div class="input-group-text bg-soft-secondary">{{ translate('Browse') }}</div>
							</div>
							<div class="form-control file-amount">{{ translate('Choose File') }}</div>
							<input type="hidden" name="types[]" value="seller_register_page_image">
							<input type="hidden" name="seller_register_page_image" value="{{ get_setting('seller_register_page_image') }}" class="selected-files">
						</div>
						<div class="file-preview box"></div>
                    <small class="text-muted">{{ translate("Minimum dimensions required: 945px width X 1036px height.") }}</small>
					</div>
				@endif


				@if (addon_is_activated('delivery_boy'))
					<!-- Delivery Boy Login page Background -->
					<div class="form-group col-lg-6">
						<label class="from-label fs-13">{{ translate('Delivery Boy Login Page Image') }}</label>
						<div class="input-group " data-toggle="aizuploader" data-type="image">
							<div class="input-group-prepend">
								<div class="input-group-text bg-soft-secondary">{{ translate('Browse') }}</div>
							</div>
							<div class="form-control file-amount">{{ translate('Choose File') }}</div>
							<input type="hidden" name="types[]" value="delivery_boy_login_page_image">
							<input type="hidden" name="delivery_boy_login_page_image" value="{{ get_setting('delivery_boy_login_page_image') }}" class="selected-files">
						</div>
						<div class="file-preview box"></div>
                    <small class="text-muted">{{ translate("Minimum dimensions required: 945px width X 839px height.") }}</small>
					</div>
				@endif

				<!-- Forgot Password Page Image -->
				<div class="form-group col-lg-6">
					<label class="from-label fs-13">{{ translate('Forgot password') }}</label>
					<div class="input-group " data-toggle="aizuploader" data-type="image">
						<div class="input-group-prepend">
							<div class="input-group-text bg-soft-secondary">{{ translate('Browse') }}</div>
						</div>
						<div class="form-control file-amount">{{ translate('Choose File') }}</div>
						<input type="hidden" name="types[]" value="forgot_password_page_image">
						<input type="hidden" name="forgot_password_page_image" value="{{ get_setting('forgot_password_page_image') }}" class="selected-files">
					</div>
					<div class="file-preview box"></div>
                    <small class="text-muted">{{ translate("Minimum dimensions required: 945px width X 839px height.") }}</small>
				</div>

				<!-- Password Reset Page Image -->
				<div class="form-group col-lg-6">
					<label class="from-label fs-13">{{ translate('Password Reset Page Image') }}</label>
					<div class="input-group " data-toggle="aizuploader" data-type="image">
						<div class="input-group-prepend">
							<div class="input-group-text bg-soft-secondary">{{ translate('Browse') }}</div>
						</div>
						<div class="form-control file-amount">{{ translate('Choose File') }}</div>
						<input type="hidden" name="types[]" value="password_reset_page_image">
						<input type="hidden" name="password_reset_page_image" value="{{ get_setting('password_reset_page_image') }}" class="selected-files">
					</div>
					<div class="file-preview box"></div>
                    <small class="text-muted">{{ translate("Minimum dimensions required: 945px width X 839px height.") }}</small>
				</div>

				@if (addon_is_activated('otp_system'))
					<div class="form-group col-lg-6">
						<label class="from-label fs-13">{{ translate('Phone Number Verification Page Image') }}</label>
						<div class="input-group " data-toggle="aizuploader" data-type="image">
							<div class="input-group-prepend">
								<div class="input-group-text bg-soft-secondary">{{ translate('Browse') }}</div>
							</div>
							<div class="form-control file-amount">{{ translate('Choose File') }}</div>
							<input type="hidden" name="types[]" value="phone_number_verify_page_image">
							<input type="hidden" name="phone_number_verify_page_image" value="{{ get_setting('phone_number_verify_page_image') }}" class="selected-files">
						</div>
						<div class="file-preview box"></div>
                    <small class="text-muted">{{ translate("Minimum dimensions required: 945px width X 839px height.") }}</small>
					</div>
				@endif
			</div>

			<!-- Update Button -->
			<div class="mt-4 text-right">
				<button type="submit" class="btn btn-success w-230px btn-md rounded-2 fs-14 fw-700 shadow-success">{{ translate('Update') }}</button>
			</div>
		</form>
	</div>
</div>

@endsection

@section('modal')
	<div class="image-show-overlay" id="image-show-overlay">
		<div class="d-flex justify-content-end my-3 mr-3">
			<button type="button" class="btn text-white d-flex align-items-center justify-content-center"><i class="las la-2x la-times"></i></button>
		</div>
		<div class="overlay-img">
			<img src="{{ static_asset('assets/img/authentication_pages/boxed.png') }}" class="w-100" alt="img-show">
		</div>
	</div>
@endsection

@section('script')
	<script>
		function imageShowOverlay(img){
			$('#image-show-overlay .overlay-img img').attr('src', '').prop('src', img);
			$('#image-show-overlay').addClass('show');
			$('.aiz-main-wrapper').css('height', '100vh');
			$('.aiz-main-wrapper').css('overflow-y', 'hidden');
		}

		$('#image-show-overlay .btn').click(function(){
			imageHideOverlay();
		});

		$('.overlay-img').click(function(e){
			if (e.target.closest('.overlay-img img')) {
				e.stopPropagation();
				return false;
			}
			imageHideOverlay();
		});

		function imageHideOverlay(){
			if($('#image-show-overlay').hasClass('show')){
				$('#image-show-overlay').removeClass('show');
			}
			$('.aiz-main-wrapper').css('height', '100%');
			$('.aiz-main-wrapper').css('overflow-y', 'auto');
		}
	</script>
@endsection
